﻿/*:
-------------------------------------------------------------------------
@title Conditional Choice Text
@author Hime --> HimeWorks (http://himeworks.com)
@version 1.1
@date Dec 27, 2015
@filename HIME_ConditionalChoiceText.js
@url http://himeworks.com/2015/11/conditional-choice-text/

If you enjoy my work, consider supporting me on Patreon!

* https://www.patreon.com/himeworks

If you have any questions or concerns, you can contact me at any of
the following sites:

* Main Website: http://himeworks.com
* Facebook: https://www.facebook.com/himeworkscom/
* Twitter: https://twitter.com/HimeWorks
* Youtube: https://www.youtube.com/c/HimeWorks
* Tumblr: http://himeworks.tumblr.com/
-------------------------------------------------------------------------
@plugindesc v1.1 - Allows you to dynamically set the text for each choice
in your events.
@help 
-------------------------------------------------------------------------
== Description ==

RPG Maker allows you to offer your players choice selection, and
depending on which choice they pick, your events will behave differently.

However, what happens if you wanted to have a particular choice display
a different text, depending on whether certain conditions have been met?
Maybe if you haven't found an item that allows you to understand what the
locals are saying in a foreign language, all of the text that is shown
will be garbled.

In particular, if you combine it with a plugin that allows you to disable
choices, you could show question marks instead of the actual text.

With this plugin, you can easily change a choice's text using events.

== Terms of Use ==

- Free for use in non-commercial projects with credits
- Contact me for commercial use

== Change Log ==

1.1 - Dec 27, 2015
 * choice text is now evaluated in the interpreter
 * game message returns choices with updated text
1.0 - Nov 6, 2015
 * initial release
 
== Usage == 

There are two ways to set the choice text.

1. Using a plugin command.

Create a plugin command and write

  choice_text choiceNumber customText
  
Where the `choiceNumber` is the number of the choice that the text
will apply to, and `customText` is the text that you want to change
to. You can include spaces in your text.

For example, if you want to change the second choice's text to
"???" you can write

  choice_text 2 ???
  
It is up to you to set up the conditional branches appropriately.

2. Using a script call

Create a script call and write

  this.choice_text(choiceNumber, customText, condition)
  
Where the `choiceNumber` is the number of the choice that the text
will apply to, and `customText` is the text that you want to change
to.

The `condition` is a valid formula that evaluates to true or false.
The specified choice's text will only be changed if the condition
is true.

To change the second choice's text to ??? assuming switch 3 is OFF,
you can write

  this.choice_text(2, "???", "$gameSwitches.value(1) === false")

-------------------------------------------------------------------------
 */ 
var Imported = Imported || {};
var TH = TH || {};
Imported.ConditionalChoiceText = 1;
TH.ConditionalChoiceText = TH.ConditionalChoiceText || {};

(function ($) {

  /* store the text for each choice */
  var TH_ConditionalChoiceText_GameMessage_Clear = Game_Message.prototype.clear;
  Game_Message.prototype.clear = function() {
    TH_ConditionalChoiceText_GameMessage_Clear.call(this);
    this._customChoiceText = {};
  };
  
  /* Replace each choice text if needed */
  var TH_GameMessage_choices = Game_Message.prototype.choices;
  Game_Message.prototype.choices = function() {
//this gets called over and over when on a choice window
    var res = TH_GameMessage_choices.call(this);
		var txta
		var txtb
		
		//this._customChoiceText gets set, then immediately cleared?
    for (var key in this._customChoiceText) {
//			console.log(this._customChoiceText[key]) // = new text
//			console.log(key) // = choice index
//			console.log(res[key]) //original choice txt

			if ((this._customChoiceText[key]).substr(0,10) == "textappend") {
				if (!res[key].includes(this._customChoiceText[key].substr(10))) {
					res[key] += " " + this._customChoiceText[key].substr(10)
				}
			}
			else if ((this._customChoiceText[key]).substr(0,10) == "textbppend") {
				txtb = this._customChoiceText[key].substr(10)
				
				if (res[key] && !res[key].includes(txtb)) {
					if ($gameScreen._pictures[20]) { //small choices
						var ln = 38
						if (Utils.isMobileDevice()) {ln = 42}
					
						if (res[key]) {
					
							while (res[key].length + txtb.length < ln) {
								txtb = " " + txtb
							}
						}
					}
					else {
						txtb = " " + txtb
					}
					
					res[key] += txtb
				}
			}
			else {
				res[key] = this._customChoiceText[key]
			}
    }
	
	for (var i = 0; i <= res.length; i++) {
		if (res[i]) {
			if (res[i].includes("undefined[")) {
				res.splice(i)
			}
		}
		else {
			res.splice(i)
		}
	}
	
    return res;
  };

  
  /* Returns the custom text for the given choice */
  Game_Message.prototype.choiceText = function(choiceNum) {
    return this._customChoiceText[choiceNum];
  }

	Game_Message.prototype.setChoiceText = function(choiceNum, text) {
		if (this._customChoiceText[choiceNum]) {
			if ((this._customChoiceText[choiceNum]).substr(0,10) == "textappend") {
				this._customChoiceText[choiceNum] = text + " " + this._customChoiceText[choiceNum].substr(10)
			}
			else if ((this._customChoiceText[choiceNum]).substr(0,10) == "textbppend") {
				if ($gameScreen._pictures[20]) { //small choices
					var a = text
					var b = this._customChoiceText[choiceNum].substr(10)
					
					var ln = 38
					if (Utils.isMobileDevice()) {ln = 33}

					while (a.length + b.length < ln) {
						a += " "
					}
					this._customChoiceText[choiceNum] = a + b
				}
				else {
					this._customChoiceText[choiceNum] = text + " " + this._customChoiceText[choiceNum].substr(10)
				}
			}
		}
		else {
			this._customChoiceText[choiceNum] = text;
		}
	
	}
	
	Game_Message.prototype.xppChoiceText = function(choiceNum) {
		delete this._customChoiceText[choiceNum]
	}
	
  Game_Message.prototype.appChoiceText = function(choiceNum, text) {
		if (this._customChoiceText[choiceNum]) {
			this._customChoiceText[choiceNum] = this._customChoiceText[choiceNum] + " " + text;
		}
		else {
			this._customChoiceText[choiceNum] = "textappend" + text;
		}
  }

  Game_Message.prototype.bppChoiceText = function(choiceNum, text) {
		if (text == "[Attack]") {
			var a1 = $gameActors.actor(1)._equips[18]._item._itemId
			var a2 = $gameActors.actor(1)._equips[19]._item._itemId

			//$dataArmors[a1].params[3] //atk
			//$dataArmors[a1].params[5] //ero

			var type = 0 //str
			
			if (a1 == 0) {
				if (a2 != 0) {
					//a1 none, a2 wpn
					if ($dataArmors[a2].note.includes("nimble")) {
						type = 1
					}
					else if ($dataArmors[a2].params[5] >= 1 &&
					$dataArmors[a2].params[3] == 0) {
						type = 2
					}
				}
			}
			else {
				if (a2 == 0) {
					//a1 wpn, a2 none
					if ($dataArmors[a1].note.includes("nimble")) {
						type = 1
					}
					else if ($dataArmors[a1].params[5] >= 1 &&
					$dataArmors[a1].params[3] == 0) {
						type = 2
					}
				}
				else {
					//a1 wpn, a2 wpn
					if ($dataArmors[a1].note.includes("nimble") &&
					$dataArmors[a2].note.includes("nimble")) {
						type = 1
					}
					else if ($dataArmors[a1].params[5] >= 1 &&
					$dataArmors[a1].params[3] == 0 &&
					$dataArmors[a2].params[5] >= 1 &&
					$dataArmors[a2].params[3] == 0) {
						type = 2
					}
				}
			}

			if (type <= 1) { //has str or nim effects
				if (type == 0) {text = "[Str: "}
				else {text = "[Nim: "}
			
				var atk1 = $gameActors.actor(1).atk - 1
				var atk2 = $gameActors.actor(1).def - 1
				
				if (text == "[Str: ") {
					atk1 += str()
					atk2 += str()
				}
				else if (text == "[Nim: ") {
					atk1 += nim()
					atk2 += nim()
				}
				atk1 *= v(13)
				atk1 /= v(34)
				atk2 *= v(13)
				atk2 /= v(34)
				
				atk1 = Math.round(atk1)
				atk2 = Math.round(atk2)
				if (isNaN(atk1)) {	atk1 = 0	}
				if (isNaN(atk2)) {	atk2 = 0	}
				text += atk1 + "-" + atk2 + "]"
			}

			if (a1 == 0) {
				if (a2 != 0) {
					//a1 none, a2 wpn
					if ($dataArmors[a2].params[5] >= 1) {
						type = 2
					}
				}
			}
			else {
				if (a2 == 0) {
					//a1 wpn, a2 none
					if ($dataArmors[a1].params[5] >= 1) {
						type = 2
					}
				}
				else {
					//a1 wpn, a2 wpn
					if ($dataArmors[a1].params[5] >= 1 ||
					$dataArmors[a2].params[5] >= 1) {
						type = 2
					}
				}
			}
			
			if (type == 2) {
				text += "[Ero: "

				var atk1 = $gameActors.actor(1).mat - 1
				var atk2 = $gameActors.actor(1).mdf - 1
				
//				atk1 += ero()
//				atk2 += ero()
				
				atk1 = Math.round(atk1)
				atk2 = Math.round(atk2)
				if (isNaN(atk1)) {	atk1 = 0	}
				if (isNaN(atk2)) {	atk2 = 0	}
				text += atk1 + "-" + atk2 + "]"
				
			}
		}
		
		
		else if (text == "[Erotic]") { //unused
			text = "[Ero]"
			var atk1 = parseInt(5 / $gameVariables.value(36))
			var atk2 = parseInt((15 + ero()) / $gameVariables.value(36))
			
			atk1 = Math.round(atk1)
			atk2 = Math.round(atk2)
			if (isNaN(atk1)) {	atk1 = 0	}
			if (isNaN(atk2)) {	atk2 = 0	}
			text += "[" + atk1 + "-" + atk2 + "]"
		}
		
		
		else if (text == "[Escape]") {
			text = "[Nim]"
			var atk1 = parseInt(nim() / 2)
			if (atk1 < 1) {atk1 = 1}
			var atk2 = 1 + nim()
			
			atk1 = Math.round(atk1)
			atk2 = Math.round(atk2)
			if (isNaN(atk1)) {	atk1 = 0	}
			if (isNaN(atk2)) {	atk2 = 0	}
			text += "[" + atk1 + "-" + atk2 + "]"
		}
		
		else if (text.includes("[ammo")) {
			num = text.match(/\d+/g)
			var ammo = "[x" + $gameParty.numItems($dataItems[parseInt(num[0])]) + "]"
			
			if ($gameParty.numItems($dataItems[parseInt(num[0])]) == 0) {
				$gameMessage.disableChoice(choiceNum, true);
			}
			
			text = ammo
		}
		
		else if (text.includes("[skill")) {
			n = text.match(/\d+/g)
			var skill
			
			if (!$gameActors.actor(1).hasSkill(n[0])) {
				$gameMessage.disableChoice(choiceNum, true);
				skill = "[Req skill!]"
			}
			else {
				if ($dataSkills[n[0]].mpCost > 0) {
					skill = "[MP " + $dataSkills[n[0]].mpCost + "]"
					if ($gameVariables.value(41) < $dataSkills[n[0]].mpCost) {
						$gameMessage.disableChoice(choiceNum, true);
					}
				}
				else if ($dataSkills[n[0]].tpCost > 0) {
					skill = "[ST " + $dataSkills[n[0]].tpCost + "]"
					if ($gameVariables.value(8) < $dataSkills[n[0]].tpCost) {
						$gameMessage.disableChoice(choiceNum, true);
					}
				}
			}
			
			text = skill
		}
		
		else if (text.includes("[cost")) {
			num = text.match(/\d+/g)
			var money = num[0].toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")
			var ammo = "[" + money + " Credits]"


			if (num[0] > $gameParty.gold()) {
				$gameMessage.disableChoice(choiceNum, true);
			}
			
			text = ammo
		}
		
		else if (text.includes("[chk")) {
			var stat, string
			var ammo = ""
			num = text.match(/\d+/g)
//			numtxt = text.match(/\w\w[^-]/g)
//			p(numtxt)
			
			if (text.includes("str")) {			stat = str(); string = "[Str]"}
			else if (text.includes("mys")) {stat = mys(); string = "[Mys]"}
			else if (text.includes("nim")) {stat = nim(); string = "[Nim]"}
			else if (text.includes("res")) {stat = res(); string = "[Res]"}
			else if (text.includes("spe")) {stat = spe(); string = "[Spe]"}
			else if (text.includes("ins")) {stat = ins(); string = "[Ins]"}
			else if (text.includes("sen")) {stat = sen(); string = "[Sen]"}
			else if (text.includes("ero")) {stat = ero(); string = "[Ero]"}
			
			if (parseInt(num[0]) > 10) {
				var a = parseInt(num[1]) + Math.round(stat / (parseInt(num[0]) - 10))
			}
			else {
				var a = parseInt(num[1]) + (stat * parseInt(num[0]))
			}
			
			if (isNaN(a)) {	a = 0	}
			
			a = a.clamp(0, 100);
			
			$gameVariables.value(144)[choiceNum][0] = parseInt(num[0])
			$gameVariables.value(144)[choiceNum][1] = parseInt(num[1])
			
			$gameVariables.value(144)[choiceNum][2] = parseInt(stat)
			
			if (num[2]) {
				ammo = "[x" + $gameParty.numItems($dataItems[parseInt(num[2])]) + "]"
				if ($gameParty.numItems($dataItems[parseInt(num[2])]) == 0) {
					$gameMessage.disableChoice(choiceNum, true);
				}
			}
			
			text = ammo + string + "[" + a + "%]"
		}
		

		if (this._customChoiceText[choiceNum]) {
			this._customChoiceText[choiceNum] = this._customChoiceText[choiceNum] + " " + text;
		}
		else {
			this._customChoiceText[choiceNum] = "textbppend" + text;
		}
  }
	
  
  /* Use a plugin command*/
  var TH_ConditionalChoiceText_GameInterpreterPluginCommand = Game_Interpreter.prototype.pluginCommand;
  Game_Interpreter.prototype.pluginCommand = function(command, args) {
    TH_ConditionalChoiceText_GameInterpreterPluginCommand.call(this, command, args);    
    if (command.toLowerCase() === "tc") {
      var choiceNum = Math.floor(args[0] - 1);
      var text = args.slice(1).join(" ")
      $gameMessage.setChoiceText(choiceNum, text);
    }
    else if (command.toLowerCase() === "tca") {
      var choiceNum = Math.floor(args[0] - 1);
      var text = args.slice(1).join(" ")
      $gameMessage.appChoiceText(choiceNum, text);
    }
    else if (command.toLowerCase() === "tcb") {
      var choiceNum = Math.floor(args[0] - 1);
      var text = args.slice(1).join(" ")
      $gameMessage.bppChoiceText(choiceNum, text);
    }
    else if (command.toLowerCase() === "tcx") {
      var choiceNum = Math.floor(args[0] - 1);
      $gameMessage.xppChoiceText(choiceNum);
    }
		
		
		else if (command.toLowerCase() === "r100") {
			var rand = Math.randomInt(101)
			var lastchoice = $gameVariables.value(6) - 1
			
			rand += $gameVariables.value(144)[lastchoice][1]
			
			if ($gameVariables.value(144)[lastchoice][0] > 10) {
				rand += Math.round(($gameVariables.value(144)[lastchoice][2] / ($gameVariables.value(144)[lastchoice][0]-10)))
			}
			else {
				rand += ($gameVariables.value(144)[lastchoice][2] * $gameVariables.value(144)[lastchoice][0])
			}
			
			$gameVariables.setValue(1, rand);
		}
		
    return true;
  };
  
  Game_Interpreter.prototype.tc = function(choiceNum, text) {
    var num = Math.floor(choiceNum) - 1;    
    $gameMessage.setChoiceText(num, text);
  };
  
  /* Use a script call */
  tc = function(choiceNum, text) {
    var num = Math.floor(choiceNum) - 1;    
    $gameMessage.setChoiceText(num, text);
  };

  Game_Interpreter.prototype.tca = function(choiceNum, text) {
    var num = Math.floor(choiceNum) - 1;    
    $gameMessage.appChoiceText(num, text);
  };
  
  tca = function(choiceNum, text) {
    var num = Math.floor(choiceNum) - 1;
    $gameMessage.appChoiceText(num, text);
  };
	
  Game_Interpreter.prototype.tcb = function(choiceNum, text) {
    var num = Math.floor(choiceNum) - 1;    
    $gameMessage.bppChoiceText(num, text);
  };
	
	tcb = function(choiceNum, text) {
    var num = Math.floor(choiceNum) - 1;
    $gameMessage.bppChoiceText(num, text);
	};

  Game_Interpreter.prototype.tcx = function(choiceNum) {
    var num = Math.floor(choiceNum) - 1;    
    $gameMessage.xppChoiceText(num);
  };
	
	tcx = function(choiceNum) {
    var num = Math.floor(choiceNum) - 1;
    $gameMessage.xppChoiceText(num);
	};
	
	
})(TH.ConditionalChoiceText);


